/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include "coroutinewaitcondition.h"
#include "coroutine.h"

// #define DEBUG_COROUTINEWAITCONDITION
#ifdef DEBUG_COROUTINEWAITCONDITION
#define coDebug(x) qDebug x
#else
#define coDebug(x) do { } while(false)
#endif

CoroutineWaitCondition::CoroutineWaitCondition()
{
}

CoroutineWaitCondition::~CoroutineWaitCondition()
{
    coDebug(("%p: CoroutineWaitCondition::~CoroutineWaitCondition", Coroutine::currentCoroutine()));
    wakeAll();
}

void CoroutineWaitCondition::wakeOne()
{
    coDebug(("%p: CoroutineWaitCondition::wakeOne: %d coroutines waiting", Coroutine::currentCoroutine(), mWaiting.size()));
    if (mWaiting.isEmpty())
        return;
    Coroutine *coroutine = mWaiting.takeFirst();
    coDebug(("%p: CoroutineWaitCondition::wakeOne: continuing %p", Coroutine::currentCoroutine(), coroutine));
    coroutine->cont();
    coDebug(("%p: CoroutineWaitCondition::wakeOne: after continue", Coroutine::currentCoroutine()));
}

void CoroutineWaitCondition::wakeAll()
{
    coDebug(("%p: CoroutineWaitCondition::wakeAll: %d coroutines waiting", Coroutine::currentCoroutine(), mWaiting.size()));
    QList<Coroutine *> coroutines(mWaiting);
    mWaiting.clear();
    foreach (Coroutine *coroutine, coroutines) {
        coDebug(("%p: CoroutineWaitCondition::wakeAll: continuing %p", Coroutine::currentCoroutine(), coroutine));
        coroutine->cont();
        coDebug(("%p: CoroutineWaitCondition::wakeAll: after continue", Coroutine::currentCoroutine()));
    }
}

void CoroutineWaitCondition::wait()
{
    mWaiting.append(Coroutine::currentCoroutine());
    coDebug(("%p: CoroutineWaitCondition::wait: yielding", Coroutine::currentCoroutine()));
    Coroutine::yield();
    coDebug(("%p: CoroutineWaitCondition::wait: after yield", Coroutine::currentCoroutine()));
}

bool CoroutineWaitCondition::hasWaiters() const
{
    return !mWaiting.isEmpty();
}
