/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef COROUTINECONT_H
#define COROUTINECONT_H

#include "coroutine.h"
#include <QObject>

/// Helper class that allows a Coroutine to be continued using a signal.
class LGPL_CORE_EXPORT CoroutineCont : public QObject
{
    Q_OBJECT
public:
    /// @a coroutine is the Coroutine to be continued when the cont slot is called.
    CoroutineCont(Coroutine *coroutine, QObject *parent = 0);

    static void yieldUntil(QObject *sender, const char *signal);
    static void yieldUntil(QObject *sender, const char *sig1, const char *sig2);
    static void yieldUntil(QObject *sender1, const char *sig1, QObject *sender2, const char *sig2);
public slots:
    /// Resumes the Coroutine passed in the constructor.
    void cont();
private:
    Coroutine *mCoroutine;
};

#endif //COROUTINECONT_H
