`DEFINES += COROUTINE_LIBRARY

HEADERS += \
    coroutine/coroutine.h \
    coroutine/coroutine_global.h \
    coroutine/coroutinebuilddeclaration_p.h \
    coroutine/coroutinebuilddefinition_p.h \
    coroutine/coroutinestoredfunctioncall_p.h \
    coroutine/coroutinemutex.h \
    coroutine/coroutinewaitcondition.h \
    coroutine/coroutinecont.h

SOURCES += coroutine/coroutine.cpp \
           coroutine/coroutinemutex.cpp \
           coroutine/coroutinewaitcondition.cpp \
           coroutine/coroutinecont.cpp

INCLUDEPATH += .
DEPENDPATH += .

unix {
    macos { ARCH=x86_64 }
    else { ARCH = $$system(arch 2>/dev/null || uname -p) }
    contains(ARCH, unknown):ARCH=$$system(uname -m)

    contains(ARCH, x86_64) {
        contains(QMAKE_CFLAGS,-m32) {
            CONFIG += x86
        } else {
            CONFIG += x86_64
        }
    } else:contains(ARCH, i386) | contains(ARCH, i486) | contains(ARCH, i586) | contains(ARCH, i686) {
        CONFIG += x86
    } else:contains(ARCH, aarch64) {
        CONFIG += aarch64
    } else:contains(ARCH, s64fx) {
        CONFIG += s64fx
    }

}

contains(QMAKE_CXX,g++) {
    win32 {
        # will fail for 64 bit win!
        SOURCES += \
            coroutine/backend/switchstack_gcc_32_win.s \
            coroutine/backend/initializestack_32.cpp
    }
    !win32 {
        CONFIG(x86_64) {
            SOURCES += \
                coroutine/backend/switchstack_gcc_64_linux_mac.s \
                coroutine/backend/initializestack_64_linux_mac.cpp
        }
        CONFIG(x86) {
            SOURCES += \
                coroutine/backend/switchstack_gcc_32_linux_mac.s \
                coroutine/backend/initializestack_32.cpp
        }
        CONFIG(aarch64) {
            SOURCES += \
                coroutine/backend/initializestack_aarch64.cpp \
                coroutine/backend/switchstack_gcc_aarch64_linux_mac.s
        }
        CONFIG(s64fx) {
            SOURCES += \
                coroutine/backend/switchstack_s64fx.s \
                coroutine/backend/initializestack_s64fx.cpp
        }

    }
}

win32:contains(QMAKE_CXX,cl) {
     SOURCES += \
    	coroutine/backend/switchstack_msvc.cpp \
        coroutine/backend/initializestack_msvc.cpp
}

