#!/bin/sh

FORGE_SUITE_DIRECTORY=licenceserver
FORGE_SUITE_FULL_NAME="Linaro Forge Licence Server"
FORGE_SUITE_REVISION=25.0.4
FORGE_SUITE_TARBALL_NAME=licenceserver
TOOLS_BUILD_ARCH=aarch64

TOOLS_RUN_ARCH="$(uname -m)"
INSTALL_USER="$(whoami)"

accept_licence=
if [ "$1" = "--accept-licence" -o "$1" = "--accept-license" ]; then
	accept_licence=1
	shift
fi

if [ $# -gt 1 ]; then
	echo "Usage: $(basename $0) [--accept-license] [installation-directory]"
	exit 1
fi

DIRECTORY=
if [ -n "$1" ]; then
	DIRECTORY="$1"
fi

if [ "${TOOLS_RUN_ARCH}" != "${TOOLS_BUILD_ARCH}" -a "${TOOLS_BUILD_ARCH}" != k1om ] ; then
    echo
    echo "Your machine uses the $TOOLS_RUN_ARCH architecture but this ${FORGE_SUITE_FULL_NAME} installation tarball is for the $TOOLS_BUILD_ARCH architecture."
    echo
    echo "We recommend you download the $TOOLS_RUN_ARCH architecture tarball from the website instead."
    echo
    echo "Do you wish to continue (y/N)?"
    echo
    read answer
    case $answer in
        [Yy]*) ;;
        *) exit ;;
    esac
fi

if(test ${INSTALL_USER} = root)
then
	DEFAULT=/opt/linaro/${FORGE_SUITE_DIRECTORY}/${FORGE_SUITE_REVISION}
else
	DEFAULT=$HOME/linaro/${FORGE_SUITE_DIRECTORY}/${FORGE_SUITE_REVISION}
fi

cd `dirname $0`
INSTALL_FROM_DIR=`pwd`

echo "${FORGE_SUITE_FULL_NAME}"
echo "Copyright (c) 2023-2025 Linaro Limited. All rights reserved."
echo "==============================================================="
echo
echo "Version ${FORGE_SUITE_REVISION}"
echo
echo This is the install script for ${FORGE_SUITE_FULL_NAME}.
echo
echo By proceeding with this installation, you agree to be bound by
echo Linaro licensing conditions. The licensing conditions are contained
echo in the file license_agreement and supplementary_terms.txt which
echo is extracted from the same archive file as this script.

if [ -n "$accept_licence" ]; then
	cat ./license_terms/license_agreement.txt
    echo 
    cat ./license_terms/supplementary_terms.txt
	echo
	echo "License accepted..."
else
	echo Press Enter to read the license.
	read KEY

	cat ./license_terms/license_agreement.txt
    echo 
    cat ./license_terms/supplementary_terms.txt
    echo 

	while [ "$KEY" != "a" ]; do
	echo "Select (a) to AGREE to terms of this license"
	echo "Select (q) if you do not agree to the terms of this license"
	read KEY

	case $KEY in
		'a') ;;
		'q') exit 1
	esac
	done
fi

echo

if [ -z "$DIRECTORY" ]; then
	echo "You now need to select a directory in which to install ${FORGE_SUITE_FULL_NAME}."
	echo "This directory must be accessible on all the nodes in your"
	echo "cluster."
	echo

	echo "The default install base of ${FORGE_SUITE_FULL_NAME} is $DEFAULT"
	echo "Enter another directory (without spaces or tabs) or press Enter to use default: "

	read DIRECTORY REMAINING; if [ -n "$REMAINING" ]; then
		echo 'Enter a directory without spaces or tabs.' >&2
		exit
	fi

	if [ "$DIRECTORY" = "" ]; then
	    DIRECTORY=$DEFAULT
	fi
fi

if  (test -d "$DIRECTORY") ;then
    echo 'Directory exists - continuing'
elif (test -e $DIRECTORY) ;  then
    echo $DIRECTORY exists and is not a directory, aborting install
    exit
else mkdir --mode=go-w --parents "$DIRECTORY" || {
	echo Unable to create directory, aborting install;
	exit
	}
    echo 'Made directory - continuing'
fi

cd "$DIRECTORY"
gunzip -dc "$INSTALL_FROM_DIR/${FORGE_SUITE_TARBALL_NAME}.tgz" |
tar --no-same-owner --no-same-permissions -xvf - ||  {
    echo '** An error was encountered, aborting install'
    exit
}

chmod -R a+rx bin
chmod -R a+rx libexec
chmod -R a+r doc
if [ -d examples ]; then
    chmod -R a+r examples
fi
if [ -d help ]; then
    chmod -R a+r help
fi

if [ -x /bgsys -a -n "$MMCS_SERVER_IP" ]; then
    cp /usr/X11R6/lib/libX11.so.6 lib/
    cp /usr/X11R6/lib/libXext.so.6 lib/
fi

echo 'Finishing installation. This may take a few minutes...'

if [ -f ./map-mime.xml ]; then
    xdg-mime install map-mime.xml 2>/dev/null
    rm ./map-mime.xml
fi

if [ -x ./post-install.sh ]; then
    ./post-install.sh
    rm ./post-install.sh
fi

echo
echo
echo Please read the RELEASE-NOTES file in the
echo $DIRECTORY/doc directory
echo
echo 'IMPORTANT'
echo '========='
echo
echo 'You now need to visit '
echo 'https://www.linaroforge.com/freeTrial'
echo 'to obtain a combined trial license for Linaro DDT, Linaro MAP and'
echo 'Linaro Performance Reports.'
echo -----------------------------------------------------
echo 'Please contact support@forge.linaro.com for support.'
echo =====================================================
